//
//  menuViewController.swift
//  sideMenu1111
//
//  Created by juger on 8/6/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
import SwiftyJSON
import Alamofire

protocol toDismissDelegate
{
    func toDismiss()
}



class menuViewController: BaseVC , UITableViewDelegate , UITableViewDataSource {

    //MARK: - Outlets
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var imageView: UIImageView!
//    @IBOutlet weak var heightOfTableView: NSLayoutConstraint!
    @IBOutlet weak var logoutButton: UIButton!
//    @IBOutlet weak var topConstraint: NSLayoutConstraint!
    
    @IBOutlet weak var lbl: UILabel!
    let storyboardMain : UIStoryboard = UIStoryboard.init(name: "Main", bundle: nil)

    
    var delegate : toDismissDelegate?
    
    //MARK: - Variables
//    let nameOfSections : [String] = ["Home","Category","Promotions" ,"Wish List","Purchase History","Favorite Addresses", "Profile"]
    
    let nameOfSections : [String] = ["Home",
                                     "Your Orders",
                                     "Your Wish Lists" ,
                                     "Your Account",
                                     "Shop by Category",
                                     "Today's Hot Deals",
                                     "Promotions",
                                     "Advertisements",
                                     "Contact Us",
                                     "Settings"]

    
    let subUrl: String = "\(BASEURL)\(logoutURL)"

    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        if userLoggedIn{
            self.logoutButton.setTitle("Log Out", for: UIControl.State.normal)
            self.lbl.text =  "Welcome " + User.getCurrentUser().Fullname
        }else{
            self.logoutButton.setTitle("Sign in or Sign up", for: UIControl.State.normal)
            self.lbl.text =  nil
        }


        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UINib(nibName: "sideMenuTableViewCell" , bundle: nil), forCellReuseIdentifier: "menuCells")
       
        //logoutButton.makeButtonWithRadius()
        // To make The image View Circular
       // makeImageViewCircular()

    }
    
    //MARK:- Actions
    @IBAction func logoutTapped(_ sender: Any) {
        if userLoggedIn {
        let params : [String : String] = ["SystemPasscode" : systemPasscode , "ID" : String(userId!)]
        getDataJson(params: params)
        }else {
//            showErrorMessage(text: "You are not logged in")
            
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
            let viewController = storyboard2.instantiateViewController(withIdentifier: "ViewController") as! ViewController
            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)

        }
    }
    //MARK: - Functions
    
    func delay(seconds: Double, completion: @escaping ()-> Void) {
        DispatchQueue.main.asyncAfter(deadline: .now() + seconds, execute: completion)
    }
    //get data from Web
    func getDataJson(params : [String : String]){
        let url : String = subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                let logoutJson : JSON = JSON(response.result.value!)
                print("Json file : \(logoutJson)")
                self.delegate?.toDismiss()
                let message = logoutJson["ErrorMessage"].stringValue
                if message == ""
                {
                    self.hideLoading()
                print("Log out done")
                isLogout = true
                    let domain = Bundle.main.bundleIdentifier!
                    UserDefaults.standard.removePersistentDomain(forName: domain)
                    UserDefaults.standard.synchronize()
                    let main = UIStoryboard.init(name: "Main", bundle: nil)
                    let vc = main.instantiateViewController(withIdentifier: "ViewController") as! ViewController
                    let app = UIApplication.shared.delegate as! AppDelegate
                    app.window?.rootViewController = vc
                    User.clearMe()
                    
                }else
                {
                    self.hideLoading()
                    self.showErrorMessage(text: message)
                }
            }else {
                self.hideLoading()
                print("Failed requset api")
                self.showErrorMessage(text: "Faild to Logout")
            }
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        tableView.reloadData()

    }
    func makeImageViewCircular()
    {
        imageView.layer.borderWidth = 1.0
        imageView.layer.masksToBounds = false
        imageView.layer.borderColor = UIColor.white.cgColor
        imageView.layer.cornerRadius = imageView.frame.size.height/2
        imageView.clipsToBounds = true
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return nameOfSections.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
//        let cell = tableView.dequeueReusableCell(withIdentifier: "menuCells", for: indexPath) as! sideMenuTableViewCell
//        cell.nameSections.text = nameOfSections[indexPath.row]
        
        let cell = tableView.dequeueReusableCell(withIdentifier: "cell", for: indexPath)
        cell.textLabel?.text = nameOfSections[indexPath.row]
        cell.textLabel?.textAlignment = .center

        cell.selectionStyle = .none
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        switch indexPath.row {
            
            //to open home page
        case 0 :
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
//            let viewController = storyboard2.instantiateViewController(withIdentifier: "HomeStoryboard") as! HomeViewController
            let viewController = storyboard2.instantiateViewController(withIdentifier: "HomeVC") as! HomeVC

            
            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            
            //to open category page
        case 1:
            if userLoggedIn {
                let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
          //      let viewController = storyboard2.instantiateViewController(withIdentifier: "PurchaseHistoryStoryboard") as! PurchaseHistoryViewController
                let viewController = storyboard2.instantiateViewController(withIdentifier: "MyOrdersVC") as! MyOrdersVC

                
                SideMenuManager.default.menuPushStyle = .replace
                SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            }else
            {
                let vc = self.storyboardMain.instantiateViewController(withIdentifier: "NotRegisterVC") as! NotRegisterVC
                vc.txt = "My Orders"
                self.navigationController?.pushViewController(vc, animated: true)
//                showErrorMessage(text: "You are not log in ")
            }
            
        case 2:
            if userLoggedIn {
                let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
//                let viewController = storyboard2.instantiateViewController(withIdentifier: "WishListStoryboard") as! WishListViewController
                let viewController = storyboard2.instantiateViewController(withIdentifier: "MyWishlistVC") as! MyWishlistVC
                
                SideMenuManager.default.menuPushStyle = .replace
                SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            }else {
                let vc = self.storyboardMain.instantiateViewController(withIdentifier: "NotRegisterVC") as! NotRegisterVC
                vc.txt = "My Wish List"
                self.navigationController?.pushViewController(vc, animated: true)
//                showErrorMessage(text: "Please Log in")
            }
        case 3:
            if userLoggedIn{
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
//            let viewController = storyboard2.instantiateViewController(withIdentifier: "ProfileStoryboard") as! ProfileViewController
            let viewController = storyboard2.instantiateViewController(withIdentifier: "ProfileVC") as! ProfileVC

            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            }else
            {
                let vc = self.storyboardMain.instantiateViewController(withIdentifier: "NotRegisterVC") as! NotRegisterVC
                vc.txt = "My Profile"
                self.navigationController?.pushViewController(vc, animated: true)
//                showErrorMessage(text: "You are not log in ")
            }

        case 4:
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
//            let viewController = storyboard2.instantiateViewController(withIdentifier: "CategoryStoryboard") as! CategoryViewController
            let viewController = storyboard2.instantiateViewController(withIdentifier: "CategoriesVC") as! CategoriesVC

//            let viewController = storyboard2.instantiateViewController(withIdentifier: "CategoryProductsStoryboard") as! CategoryProductsViewController
            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            
            //to open Promotion page
            
        case 5:
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
            let viewController = storyboard2.instantiateViewController(withIdentifier: "TodayVC") as! TodayVC
            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            
        case 6:
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
            let viewController = storyboard2.instantiateViewController(withIdentifier: "PromotionsVC") as! PromotionsVC
            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            
            //to open WishList page
            
            //to open Purchase page
        case 7:
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
            let viewController = storyboard2.instantiateViewController(withIdentifier: "ElanatVC") as! ElanatVC
            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)

            
        case 8:
            let storyboard2 = UIStoryboard(name: "Main", bundle: nil)
            let viewController = storyboard2.instantiateViewController(withIdentifier: "ContactusVC") as! ContactusVC
            
            SideMenuManager.default.menuPushStyle = .replace
            SideMenuManager.default.menuLeftNavigationController?.pushViewController(viewController, animated: true)
            
            break
        case 9:
            break

        default:
            break
        }
        tableView.deselectRow(at: indexPath, animated: true)
        
       
    }
    
    
    
}
